/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.EditorScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.CustomSlider;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.TextFieldMode;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetFactory;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EntryInfoWidgetBuilder {
    private static final Set<String> ignoreThese = Set.of("", "-", ".", "-.");

    public static List<WidgetState<?>> buildWidgets(ConfigCategory config, Naming naming, List<WidgetState<?>> knownStates, List<String> erroredEntries) {
        LinkedList knownStates2 = new LinkedList();
        for (EntryInfo info : config.getEntries()) {
            if (info.supportsRepresentation()) {
                WidgetState state = EntryInfoWidgetBuilder.initEntry(config, naming.entry(info.getName()), info, knownStates);
                knownStates.add(state);
                knownStates2.add(state);
                continue;
            }
            erroredEntries.add(info.getName());
        }
        return knownStates2;
    }

    private static <T> WidgetState<T> initEntry(ConfigCategory config, Naming.Entry naming, EntryInfo info, List<WidgetState<?>> knownStates) {
        Type type = info.getValueType();
        WidgetState state = new WidgetState();
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        WidgetFactory<Boolean> factory = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TInt.class, Type.TLong.class, Type.TFloat.class, Type.TDouble.class, Type.TString.class, Type.TBool.class, Type.TEnum.class, Type.TUnknown.class}, (Object)type3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Type.TInt tInt = (Type.TInt)type3;
                yield EntryInfoWidgetBuilder.numberWidget(info, state, new TextFieldMode.Numeric.Integer<Integer>(Integer::parseInt, Number::intValue, (int)info.getMinValue(), (int)info.getMaxValue()));
            }
            case 1 -> {
                Type.TLong tLong = (Type.TLong)type3;
                yield EntryInfoWidgetBuilder.numberWidget(info, state, new TextFieldMode.Numeric.Integer<Long>(Long::parseLong, Number::longValue, (long)info.getMinValue(), (long)info.getMaxValue()));
            }
            case 2 -> {
                Type.TFloat tFloat = (Type.TFloat)type3;
                yield EntryInfoWidgetBuilder.numberWidget(info, state, new TextFieldMode.Numeric.Decimal<Float>(Float::parseFloat, Number::floatValue, Float.valueOf((float)info.getMinValue()), Float.valueOf((float)info.getMaxValue())));
            }
            case 3 -> {
                Type.TDouble tDouble = (Type.TDouble)type3;
                yield EntryInfoWidgetBuilder.numberWidget(info, state, new TextFieldMode.Numeric.Decimal<Double>(Double::parseDouble, Number::doubleValue, info.getMinValue(), info.getMaxValue()));
            }
            case 4 -> {
                Type.TString tString = (Type.TString)type3;
                yield EntryInfoWidgetBuilder.textField(info, state, new TextFieldMode.Text((int)info.getMinValue(), (int)info.getMaxValue()));
            }
            case 5 -> {
                Type.TBool tBool = (Type.TBool)type3;
                yield EntryInfoWidgetBuilder.toggle(info, state, value -> value == false, arg_0 -> ((Naming.Entry)naming).boolValue(arg_0));
            }
            case 6 -> {
                Type.TEnum tEnum = (Type.TEnum)type3;
                Object[] values = tEnum.options();
                yield EntryInfoWidgetBuilder.toggle(info, state, value -> {
                    int index = EntryInfoWidgetBuilder.indexOf(values, value) + 1;
                    return values[index >= values.length ? 0 : index];
                }, value -> naming.enumValue(type, value));
            }
            case 7 -> {
                Type.TUnknown tUnknown = (Type.TUnknown)type3;
                LibJf.LOGGER.error("Unsupported entry type in " + info.getName() + ": " + type.getName() + " - displaying fallback", new Object[0]);
                yield EntryInfoWidgetBuilder.jsonScreen(config, info, state);
            }
        };
        Try.orThrow(() -> state.initialize(info, knownStates, factory, naming));
        return state;
    }

    private static <T extends Number> WidgetFactory<T> numberWidget(EntryInfo<T> info, WidgetState<T> state, TextFieldMode.Numeric<T> mode) {
        return EntryInfoWidgetBuilder.isDiscrete(info) ? EntryInfoWidgetBuilder.slider(info, state, mode) : EntryInfoWidgetBuilder.textField(info, state, mode);
    }

    private static int indexOf(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    private static <T> WidgetFactory<T> toggle(EntryInfo<T> info, WidgetState<T> state, UnaryOperator<T> increment, Function<T, class_2561> valueToText) {
        return (screen, textRenderer) -> {
            class_4185 button = class_4185.method_46430((class_2561)((class_2561)valueToText.apply(state.cachedValue)), btn -> {
                state.updateCache(increment.apply(state.cachedValue));
                btn.method_25355((class_2561)valueToText.apply(state.cachedValue));
            }).method_46434(screen.field_22789 - 110, 0, info.getWidth(), 20).method_46431();
            return new WidgetFactory.Widget<Object>(state, value -> button.method_25355((class_2561)valueToText.apply(value)), (class_339)button, (width, height) -> button.method_46421(width - 110));
        };
    }

    private static <T> WidgetFactory<T> textField(EntryInfo<T> info, WidgetState<T> state, TextFieldMode<T> mode) {
        state.managedTemp = false;
        boolean isNumber = mode instanceof TextFieldMode.Numeric;
        state.onUpdateCache(() -> {
            if (mode instanceof TextFieldMode.Numeric) {
                TextFieldMode.Numeric numMode = (TextFieldMode.Numeric)mode;
                state.cachedValue = EntryInfoWidgetBuilder.clamp(numMode, (Number)state.cachedValue);
            }
        });
        return (screen, textRenderer) -> {
            class_342 widget = new class_342(textRenderer, screen.field_22789 - 110, 0, info.getWidth(), 20, null);
            state.tempValue = state.cachedValue == null ? "" : state.cachedValue.toString();
            widget.method_1852(state.tempValue);
            widget.method_1890(currentInput -> {
                String boundViolated;
                if (!(currentInput = currentInput.trim()).isEmpty() && !mode.matchesPattern((String)currentInput)) {
                    return false;
                }
                Object value = isNumber && ignoreThese.contains(currentInput) ? mode.min(state.cachedValue) : mode.parse((String)currentInput);
                state.error = null;
                double size = mode.size(value);
                Object min = mode.min(value);
                Object max = mode.max(value);
                boolean tooLow = size < mode.size(min);
                boolean tooHigh = size > mode.size(max);
                boolean inLimits = !tooLow && !tooHigh;
                String boundKind = isNumber ? "value" : "length";
                String string = boundViolated = tooLow ? "minimum" : "maximum";
                state.error = inLimits ? null : class_2561.method_48322((String)("libjf-config-ui-tiny.entry.error." + boundKind + "." + boundViolated), (String)("\u00a7c" + boundViolated + " " + boundKind + " is %1$s"), (Object[])new Object[]{tooLow ? min.toString() : max.toString()}).method_27692(class_124.field_1061);
                state.tempValue = currentInput;
                widget.method_1868(inLimits ? -1 : -65536);
                state.inLimits = inLimits;
                screen.done.field_22763 = state.knownStates.stream().allMatch(st -> st.inLimits);
                if (inLimits) {
                    state.updateCache(value);
                }
                return true;
            });
            return new WidgetFactory.Widget<Object>(state, value -> widget.method_1852(value == null ? "" : value.toString()), (class_339)widget, (width, height) -> widget.method_46421(width - 110));
        };
    }

    private static <T> WidgetFactory<T> jsonScreen(ConfigCategory config, EntryInfo<T> info, WidgetState<T> state) {
        state.managedTemp = false;
        state.tempValue = null;
        return (screen, textRenderer) -> {
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-core-v2.edit"), $ -> {
                String jsonified;
                if (state.tempValue == null) {
                    try {
                        jsonified = LibJf.LENIENT_TRANSPORT.write(writer -> info.serializeOneTo(state.cachedValue, (SerializeWriter)writer));
                    }
                    catch (Throwable e) {
                        LibJf.LOGGER.error("Could not stringify element", e);
                        class_370.method_27024((class_374)screen.getClient().method_1566(), (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.read.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.read.fail.description"));
                        return;
                    }
                } else {
                    jsonified = state.tempValue;
                }
                screen.getClient().method_1507((class_437)new EditorScreen(state.naming.name(), state.naming.tooltip(), screen, jsonified, json -> {
                    try {
                        state.updateCache(LibJf.LENIENT_TRANSPORT.read(json, arg_0 -> ((EntryInfo)info).deserializeOneFrom(arg_0)));
                        state.tempValue = null;
                    }
                    catch (Throwable e) {
                        LibJf.LOGGER.error("Could not write element", e);
                        class_370.method_27024((class_374)screen.getClient().method_1566(), (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.write.fail.title"), (class_2561)class_2561.method_43471((String)"libjf-config-ui-tiny.entry.json.write.fail.description"));
                        state.tempValue = json;
                    }
                }));
            }).method_46434(screen.field_22789 - 110, 0, info.getWidth(), 20).method_46431();
            return new WidgetFactory.Widget<Object>(state, R::nop, (class_339)button, (width, height) -> button.method_46421(width - 110));
        };
    }

    private static <T extends Number> WidgetFactory<T> slider(EntryInfo<T> info, WidgetState<T> state, TextFieldMode.Numeric<T> mode) {
        double min = info.getMinValue();
        double max = info.getMaxValue();
        if (!EntryInfoWidgetBuilder.isDiscrete(min)) {
            throw new IllegalArgumentException("Attempted to create slider with indiscrete minimum");
        }
        if (!EntryInfoWidgetBuilder.isDiscrete(max)) {
            throw new IllegalArgumentException("Attempted to create slider with indiscrete maximum");
        }
        state.onUpdateCache(() -> {
            state.cachedValue = EntryInfoWidgetBuilder.clamp(mode, (Number)state.cachedValue);
        });
        return (screen, textRenderer) -> {
            CustomSlider slider = new CustomSlider(screen.field_22789 - 110, 0, info.getWidth(), 20, Double.parseDouble(state.tempValue), min, max, v -> state.updateCache(mode.specialize((double)v)), mode instanceof TextFieldMode.Numeric.Integer);
            return new WidgetFactory.Widget<Number>(state, value -> slider.setValue(value.doubleValue()), (class_339)slider, (width, height) -> slider.method_46421(width - 110));
        };
    }

    private static <T extends Number> T clamp(TextFieldMode.Numeric<T> mode, T current) {
        double cv = mode.size(current);
        T min = mode.min(current);
        T max = mode.max(current);
        return cv < mode.size(min) ? min : (cv > mode.size(max) ? max : current);
    }

    private static boolean isDiscrete(EntryInfo<?> info) {
        return EntryInfoWidgetBuilder.isDiscrete(info.getMinValue()) && EntryInfoWidgetBuilder.isDiscrete(info.getMaxValue());
    }

    private static boolean isDiscrete(double number) {
        return !Double.isNaN(number) && Double.isFinite(number);
    }
}

